# Role Name: ldap_server
This role will setup the LDAP-provider. This role will setup a single master

## Requirements
This role requires an inventory with a group of all LDAP-provider.

## Supported distributions
Debian and Ubunut

## Description
  Checks that the slapd is running
  Setting required index entries for replication
  Loading the module syncprov
  Configure the module syncprov
  Creates the "OU" for syste-users
  Creates the "OU" for system-groups
  Creating the replication-user as SimpleSecurityObject
  Creating an admin-user as SimpleSecurityObject

## Role Variables
All needed variables are in defaults/main.yml, change them to your needs.

## Dependencies
This role depends on the role ldap_server. The rolle ldap_server will do the basic setup of the LDAP_server.

## Example Playbook

Including an example of how to use your role (for instance, with variables passed in as parameters) is always nice for users too:
```
- hosts: ldap_provider
      roles:
         - ldap_server
```

## Example inventory

```
[ldap_server]
ldapmaster
ldapslave-01
ldapslave-02

[ldap_master]
ldapmaster

[ldap_slave]
ldapslave-01
ldapslave-02

[ldap_server:vars]
ansible_python_interpreter=/usr/bin/python3
ansible_user=ansible
ansible_become=yes
```

## Author Information
Stefan Kania stefan@kania-online.de
