# Role Name: ldap_server
This role will do the basic setup of both LDAP-provider and LDAP-consumer. This role will setup a single master and multiple slave environment

## Requirements
This role requires an inventory with a group of all LDAP-server. For the first run root-access via ssh with password is required. To build the right DIT-suffix and for checking
the certificate, nameresolution is required either via DNS or an identical /etc/hosts with all LDAP-servers.

## Supported distributions
Debian and Ubunut
## Description
  Tis role comes with all the neded certificates set up a test-environment. the DNS-name of the DNS-domain is "example.net". You can find all used hostnames in the example inventory
  This role will do the initial setup of all LDAP-servers in the inventory. 
  All required packages will be installed.
  A user "ansible" will be created to later on do all tasks with an non-root-account. 
  It will farther copy the public-key form the ansible-user from the ansible-host and setup sudo for the local ansible-user with no password required for sudo. 
  Inside the configuration the password for user cn=admin,cn=config and cn=root,basedn will be set.
  To allow the ansible user to change the configuration the ansible-user get's admin-permissions vi -Y EXTERNAL to cn=config and basedn.
  Some basic ACLs will be set
  setting up TLS. This requires certificate-, key- and cacer-files in files/
  rewoke the root-login with password 

Role Variables
All needed variables are in defaults/main.yml, change them to your needs.

## Dependencies
This role depends on no other roles

## Example Playbook

Including an example of how to use your role (for instance, with variables passed in as parameters) is always nice for users too:
```
- hosts: ldap_server
      roles:
         - ldap_server
```
First start of the playbook with "-u root --ask-pass" to run the script the first time with user root. After the first run sudo is configured.

## Example inventory

```
[ldap_server]
ldapmaster
ldapslave-01
ldapslave-02

[ldap_master]
ldapmaster

[ldap_slave]
ldapslave-01
ldapslave-02

[ldap_server:vars]
ansible_python_interpreter=/usr/bin/python3
ansible_user=ansible
ansible_become=yes
```
During the first run "ansible_user" and "ansible_become" must be deactivated. With this variables set the first run with "-u root --ask-pass" will not work

## Author Information
Stefan Kania stefan@kania-online.de
